package com.penpower.idcamerademo;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.penpower.camera.Define;

import java.io.File;

public class MainActivity extends AppCompatActivity implements ActivityCompat.OnRequestPermissionsResultCallback {
    private Button mCameraFrontButton;
    private Button mCameraBackButton;
    private Button mCameraNoneButton;
    private Button mCameraManuallyButton;
    private EditText mStorePathEditText;

    public static byte[] mCardJpeg = null;
    public static byte[] mPhotoJpeg = null;

    private String mSignature = "20210716linebank7vi3w5u9w4rqh648p0j703lz409s5t850r481091o2tlhj9z7fe79a9xa405g238";

    public static final class CAMERA_SIDE {
        public static final String CARD_FRONT = "CARD_FRONT";
        public static final String CARD_BACK = "CARD_BACK";
        public static final String CARD_NONE = "CARD_NONE";
        public static final String CARD_MANUALLY = "CARD_MANUALLY";
    }

    public static final String CAMERA_MODE = "CAMERA_MODE";
    public static final String CARD_FILE = "CARD_FILE";
    public static final String IS_FRONT_CAMERA = "IS_FRONT_CAMERA";

    private String mCameraMode = CAMERA_SIDE.CARD_FRONT;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        init();
    }

    private String setDefaultPath() {
        String defaultPath = getApplication().getObbDir() + File.separator + "IDCARD_IMAGE/";
        File storePath = new File(defaultPath);
        if (!storePath.exists()) {
            storePath.mkdirs(); // 資料夾不存在，則建立資料夾。
        }
        return defaultPath;
    }

//    private String setDefaultPath() {
//        String defaultPath = Environment.getExternalStorageDirectory() + File.separator + "IDCARD_IMAGE/";
//        File storePath = new File(defaultPath);
//        if (!storePath.exists()) {
//            storePath.mkdirs(); // 資料夾不存在，則建立資料夾。
//        }
//        return defaultPath;
//    }

    private void init() {
        LinearLayout cardViewLayout = findViewById(R.id.card_view_layout);
        cardViewLayout.setVisibility(View.GONE);

        mStorePathEditText = findViewById(R.id.store_path_edittext);
        mStorePathEditText.setText(setDefaultPath());

        mCameraFrontButton = findViewById(R.id.camera_button_front);
        mCameraFrontButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCameraMode = CAMERA_SIDE.CARD_FRONT;
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                    startCamera(mCameraMode);
                } else {
                    boolean needRequestPermission = checkPermission();
                    Log.i("Hank20250319", "needRequestPermission="+needRequestPermission);
                    if (needRequestPermission) {
                        ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE}, 200);
                    } else {
                        startCamera(mCameraMode);
                    }
                }
            }
        });

        mCameraBackButton = findViewById(R.id.camera_button_back);
        mCameraBackButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCameraMode = CAMERA_SIDE.CARD_BACK;
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                    startCamera(mCameraMode);
                } else {
                    boolean needRequestPermission = checkPermission();
                    if (needRequestPermission) {
                        ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE}, 200);
                    } else {
                        startCamera(mCameraMode);
                    }
                }
            }
        });

        mCameraNoneButton = findViewById(R.id.camera_button_none);
        mCameraNoneButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCameraMode = CAMERA_SIDE.CARD_NONE;
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                    startCamera(mCameraMode);
                } else {
                    boolean needRequestPermission = checkPermission();
                    if (needRequestPermission) {
                        ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE}, 200);
                    } else {
                        startCamera(mCameraMode);
                    }
                }
            }
        });

        mCameraManuallyButton = findViewById(R.id.camera_button_manually);
        mCameraManuallyButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCameraMode = CAMERA_SIDE.CARD_MANUALLY;
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                    startCamera(mCameraMode);
                } else {
                    boolean needRequestPermission = checkPermission();
                    if (needRequestPermission) {
                        ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE}, 200);
                    } else {
                        startCamera(mCameraMode);
                    }
                }
            }
        });
    }

    private void startCamera(String aCameraMode) {
        LinearLayout cardViewLayout = findViewById(R.id.card_view_layout);
        cardViewLayout.setVisibility(View.GONE);

        Log.i("Hank20250319", "mStorePathEditText="+mStorePathEditText);
        if (mStorePathEditText != null && !mStorePathEditText.getText().toString().equals("")) {
            Bundle bundle = new Bundle();
            bundle.putString(Define.CustomParameter.SIGNATURE, mSignature);
            bundle.putString(Define.CustomParameter.STORE_PATH, mStorePathEditText.getText().toString().trim());
            bundle.putString(CAMERA_MODE, aCameraMode);

            Intent intent = new Intent();
            intent.putExtras(bundle);
            intent.setClass(MainActivity.this, CameraActivity.class);
            startActivityForResult(intent, Define.Pref.REQUEST_CODE);
        } else {
            Toast.makeText(MainActivity.this, R.string.tip_please_file_path, Toast.LENGTH_SHORT).show();
        }
    }

    private boolean checkPermission() {
        int[] permission = new int[] {ActivityCompat.checkSelfPermission(MainActivity.this, Manifest.permission.CAMERA)};
        boolean needRequestPermission = false;
        for (int i = 0; i < permission.length; i++) {
            if (permission[i] == PackageManager.PERMISSION_DENIED) {
                needRequestPermission = true;
            }
        }
        return needRequestPermission;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 200: {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) { //使用者允許權限
                    boolean needRequestPermission = checkPermission();
                    if (needRequestPermission) {
                        ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 200);
                    } else {
//                        startCamera(mCameraMode);
                    }
                } else if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_DENIED) { //使用者不允許權限
                    finish();
                }
            }
            break;
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == Define.Pref.REQUEST_CODE) {
            if (data != null && data.getExtras() != null) {
                int isSuccess = data.getExtras().getInt(Define.Pref.JUDGE_CODE_ID);
                switch (isSuccess) {
                    //代表成功
                    case Define.ResultCode.SUCCESS:
                        if (mCardJpeg != null && mCardJpeg.length > 0) {
                            FrameLayout cardInfoLayout = findViewById(R.id.card_info_layout);
                            if (cardInfoLayout != null) {
                                cardInfoLayout.setVisibility(View.GONE);
                            }
                            LinearLayout cardViewLayout = findViewById(R.id.card_view_layout);
                            if (cardViewLayout != null) {
                                cardViewLayout.setVisibility(View.VISIBLE);
                            }

                            BitmapFactory.Options options = new BitmapFactory.Options();
                            options.inJustDecodeBounds = false;
                            options.inPreferredConfig = Bitmap.Config.RGB_565;
                            Bitmap myBitmap = BitmapFactory.decodeByteArray(mCardJpeg, 0, mCardJpeg.length, options);
                            if (myBitmap != null) {
                                ImageView cardViewer = findViewById(R.id.card_viewer1);
                                cardViewer.setImageBitmap(myBitmap);
                            }
                        }
                        if (mPhotoJpeg != null && mPhotoJpeg.length > 0) {
                            LinearLayout cardViewLayout = findViewById(R.id.card_view_layout);
                            if (cardViewLayout != null) {
                                cardViewLayout.setVisibility(View.VISIBLE);
                            }

                            FrameLayout cardInfoLayout = findViewById(R.id.card_info_layout);
                            if (cardInfoLayout != null) {
                                cardInfoLayout.setVisibility(View.GONE);
                            }

                            BitmapFactory.Options options = new BitmapFactory.Options();
                            options.inJustDecodeBounds = false;
                            options.inPreferredConfig = Bitmap.Config.RGB_565;
                            Bitmap myBitmap = BitmapFactory.decodeByteArray(mPhotoJpeg, 0, mPhotoJpeg.length, options);
                            if (myBitmap != null) {
                                ImageView cardViewer = findViewById(R.id.card_viewer2);
                                cardViewer.setImageBitmap(myBitmap);
                            }
                        }
                        break;
                    case Define.ResultCode.ERROR:
                        Toast.makeText(MainActivity.this, "Open Camera Fail!", Toast.LENGTH_SHORT).show();
                        break;
                    //代表沒做任何事
                    case Define.ResultCode.NONE:
                        break;
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }
}
